<?php
// 1. Limpa qualquer lixo de memoria
ob_start();
// Desativa erros na tela para nao quebrar o JSON
ini_set('display_errors', 0);
error_reporting(0);
header('Content-Type: application/json; charset=utf-8');
session_start();

// 2. Conexao com Banco (Metodo simplificado)
$pdo = null;
$pastas = ['controles/db.php', '../controles/db.php', 'api/controles/db.php', 'db.php'];

foreach ($pastas as $arquivo) {
    if (file_exists($arquivo)) {
        require_once($arquivo);
        if (function_exists('conectar_bd')) {
            try { $pdo = conectar_bd(); break; } catch (Exception $e) {}
        }
    }
}

if (!$pdo) {
    ob_end_clean();
    echo json_encode(['title'=>'Erro', 'msg'=>'Erro DB', 'icon'=>'error']);
    exit;
}

try {
    // 3. Dados do Teste
    $horas = 3;
    $rand = rand(1000, 9999);
    $usuario = "teste" . $rand;
    $senha = "t" . $rand;
    $vencimento = date('Y-m-d H:i:s', strtotime("+$horas hours"));

    // 4. Busca Pacote
    $stmt = $pdo->query("SELECT id FROM bouquets LIMIT 1");
    $pacote = $stmt->fetch(PDO::FETCH_ASSOC);
    $bouquet_id = $pacote ? $pacote['id'] : 0;

    if ($bouquet_id == 0) {
        throw new Exception("Sem pacotes cadastrados");
    }

    // 5. Insere no Banco (COM CAMPO PLANO)
    $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, bouquet_id, plano, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
            VALUES (?, ?, ?, ?, '', ?, ?, ?, 1, NOW(), 1, 0)";
    
    $pdo->prepare($sql)->execute([
        $_SESSION['admin_id'],
        $usuario,
        $usuario,
        $senha,
        $bouquet_id,
        $bouquet_id, 
        $vencimento
    ]);

    // 6. Monta a URL (Sem acentos para nao dar erro)
    $url_painel = (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'];
    
    // Tenta pegar IP do servidor
    try {
        $q = $pdo->query("SELECT server_ip, server_port FROM servers WHERE status = 1 LIMIT 1");
        $s = $q->fetch(PDO::FETCH_ASSOC);
        if ($s) {
            $ip = $s['server_ip']; // Nao usa rtrim pra evitar erro
            $port = $s['server_port'];
            if (strpos($ip, 'http') === false) $ip = "http://" . $ip;
            if ($port != 80) $ip .= ":" . $port;
            $url_painel = $ip;
        }
    } catch (Exception $e) {}

    // 7. Mensagem HARDCODED (Sem ler arquivo externo para garantir que funciona)
    // NAO USE ACENTOS AQUI POR ENQUANTO
    $msg = "TESTE RAPIDO CRIADO\n\n";
    $msg .= "User: $usuario\n";
    $msg .= "Pass: $senha\n";
    $msg .= "Vence: " . date('d/m H:i', strtotime($vencimento)) . "\n\n";
    $msg .= "URL: $url_painel\n";
    $msg .= "M3U: $url_painel/get.php?username=$usuario&password=$senha&type=m3u_plus&output=ts";

    // 8. Retorno JSON Limpo
    $html = '<div class="alert alert-success text-center">Teste Criado!</div>';
    $html .= '<textarea class="form-control" rows="10">'.$msg.'</textarea>';
    
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>';

    $retorno = [
        'modal_titulo' => 'Sucesso',
        'modal_body' => $html,
        'modal_footer' => $ft,
        'data_table' => 'atualizar'
    ];

    ob_end_clean(); // Limpa tudo
    echo json_encode($retorno); // Envia JSON
    exit;

} catch (Exception $e) {
    ob_end_clean();
    echo json_encode(['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']);
    exit;
}
?>